#include "precomp.h"

typedef struct _stack_t {
    struct _stack_t *next;
    char text[1]; // this should be the length of string_size
} stack_t;

static bool isPresent( LPCSTR lpszOldPath, LPCSTR lpszNewPath )
{
    bool present = false;
    LPSTR pCopyOfPath = strdup(lpszOldPath);
    if( pCopyOfPath )
    {
        char* token = strtok( pCopyOfPath, ";" );
        while( token != NULL )
        {
            if( !stricmp( token, lpszNewPath ) )
            {
                present = true;
                break;
            }
            token = strtok( NULL, ";" );
        }
        free(pCopyOfPath);
    }
    return present;
}

static bool DoAddToPath( LPCSTR lpszPath )
{
    HKEY hKey;
    bool success = false;

    LONG lResult = RegOpenKeyEx( HKEY_LOCAL_MACHINE, 
                                 "SYSTEM\\CurrentControlSet\\Control\\Session Manager\\Environment", 
                                 0,
                                 KEY_READ|KEY_WRITE,
                                 &hKey );
    if( lResult == ERROR_SUCCESS )
    {
        char szExistingPath[10240] = "";
        DWORD dwDataSize = sizeof(szExistingPath), dwType = 0;

        lResult = RegQueryValueEx( hKey, "Path", 0, &dwType, (LPBYTE) szExistingPath, &dwDataSize );
        if( (lResult == ERROR_SUCCESS) && (dwType == REG_SZ) )
        {
            if( !szExistingPath[0] )
                strcpy( szExistingPath, "%SystemRoot%\\system32;%SystemRoot%" );

            if( !isPresent(szExistingPath,lpszPath) )
            {
                sprintf( szExistingPath + strlen(szExistingPath), ";%s", lpszPath );
                success = (RegSetValueEx( hKey, "Path", 0, REG_SZ, (BYTE*) szExistingPath, strlen(szExistingPath)+1 ) == ERROR_SUCCESS);
            }
            else success = true;
        }
        RegCloseKey( hKey );
    }
    return success;
}

static bool SetRuntime( LPCSTR lpszPath )
{
    HKEY hKey;
    bool success = false;

    LONG lResult = RegOpenKeyEx( HKEY_LOCAL_MACHINE, 
                                 "SYSTEM\\CurrentControlSet\\Control\\Session Manager\\Environment", 
                                 0,
                                 KEY_WRITE,
                                 &hKey );
    if( lResult == ERROR_SUCCESS )
    {
        success = (RegSetValueEx( hKey, "NAPYR_PATH", 0, REG_SZ, (BYTE*) lpszPath, strlen(lpszPath)+1 ) == ERROR_SUCCESS);
        RegCloseKey( hKey );
    }
    return success;
}

void AddToPath(HWND hParent, int iStringSize, char* variables, stack_t** stacktop)
{
    stack_t* sp = *stacktop;
    if( sp )
    {
        DoAddToPath( sp->text );
        SetRuntime( sp->text );
    }
}


