!define MUI_PRODUCT "napyr"
!define MUI_VERSION "1.1"

!define MUI_NAME "napyr ${MUI_VERSION}" ;Installer name

!define VER_MAJOR 1
!define VER_MINOR 1

OutFile .\napyr-${VER_MAJOR}.${VER_MINOR}.exe

SetCompressor bzip2

!ifndef CLASSIC_UI

  !include "${NSISDIR}\Contrib\Modern UI\System.nsh"

  !define MUI_DIRECTORYPAGE
  !define MUI_FINISHPAGE
  
  !define MUI_ABORTWARNING
  !define MUI_UNINSTALLER
  !define MUI_UNCONFIRMPAGE

  ;NSIS updates no system files
  !define MUI_TEXT_WELCOME_INFO "\r\n\r\nThis will install ${MUI_PRODUCT} on your computer.\r\n\r\n\r\n\r\n"

  !insertmacro MUI_LANGUAGE "English"

  !define MUI_UI "${NSISDIR}\Contrib\UIs\modern2.exe"
  
  !insertmacro MUI_SYSTEM
  
!endif

ShowInstDetails show
ShowUninstDetails show
SetOverwrite on
SetDateSave on

InstallDir $PROGRAMFILES\p-nand-q.com\napyr
InstallDirRegKey HKCU SOFTWARE\p-nand-q.com\napyr ""

!insertmacro MUI_RESERVEFILE_INSTALLOPTIONS
!insertmacro MUI_RESERVEFILE_SPECIALINI
!insertmacro MUI_RESERVEFILE_SPECIALBITMAP

Section "napyr (required)" SecCore
    
    ; Set output path to the installation directory.
    SetOutPath $INSTDIR
    
    ; pack the dll in the install file
    File "..\nsis\release\napyr.dll"
    
    Push "$INSTDIR"
    CallInstDLL $INSTDIR\napyr.dll AddToPath
    
    File "DATA\*"
    
    ; Write the installation path into the registry
    WriteRegStr HKCU "SOFTWARE\p-nand-q.com\napyr" "Install_Dir" "$INSTDIR"
    
    ; Write the uninstall keys for Windows
    WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\napyr" "DisplayName" "napyr (remove only)"
    WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\napyr" "UninstallString" '"$INSTDIR\uninstall.exe"'
        
    WriteUninstaller "uninstall.exe"
    SetRebootFlag true
SectionEnd

Section Uninstall
    
    ; remove registry keys
    DeleteRegKey HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\napyr"
    DeleteRegKey HKCU SOFTWARE\p-nand-q.com\napyr
       
    RMDIR /R $INSTDIR
    
    ; MUST REMOVE UNINSTALLER, too
    Delete $INSTDIR\uninstall.exe
    
    RMDir "$INSTDIR"

!ifndef CLASSIC_UI
  !insertmacro MUI_UNFINISHHEADER
!endif
SectionEnd
