variables = {}
local_variables = {}
functions = {}
debugmode = 0

"""This module contains all statements known to man. Well, sort of...
"""

class FuncDefStatement:
    def __init__(self,name=None):
        global functions
        functions[name] = self
        self.name = name
        self.instruction = None
        self.arguments = None

    def get(self):
        return None # self.instruction.get()

class FuncCallStatement:
    def __init__(self,name=None,args=None):
        self.name = name
        self.args = args

    def get(self):
        global local_variables, functions
        copy_of_local_variables = local_variables
        local_variables = {}
        function = functions[self.name]
        for i in range(len(function.arguments)):
            local_variables[function.arguments[i]] = self.args[i].get()
        result = function.instruction.get()        
        local_variables = copy_of_local_variables
        return result

class VariableStatement:
    def __init__(self,name=None,initial_value = 0):
        global variables
        self.name = name
        if not variables.has_key(name):
            variables[name] = initial_value           

    def setname(self,name,initial_value = 0):
        self.name = name
        if not variables.has_key(name):
            variables[name] = initial_value           
        
    def get(self):
        global variables, local_variables
        if local_variables.has_key(self.name):
            result = local_variables[self.name]
        else:
            result = variables[self.name]
        return result

    def set(self,value):
        global variables, local_variables
        if local_variables.has_key(self.name):
            local_variables[self.name] = value
        else:
            variables[self.name] = value

class StatementBlock:
    def __init__(self,statements=None):
        self.statements = statements

    def get(self):
        global debugmode
        result = 0
        for i in range(len(self.statements)):
            if debugmode:
                print str(self.statements[i])
            result = self.statements[i].get()
        return result

# -------------------------- ARITHMETIC FUNCTIONS ----------------------
# Convention: returns "source" <operation> "target"

class CommonAssignmentStatement:
    def __init__(self,source=None,target=None):
        self.source = source
        self.target = target

class AssignmentStatement(CommonAssignmentStatement):
    def get(self):
        self.source.set(self.target.get())
        return self.source.get()

class AddSelfStatement(CommonAssignmentStatement):
    def get(self):
        self.source.set(self.source.get()+self.target.get())
        return self.source.get()

class AddStatement:
    def get(self):
        return self.source.get() + self.target.get()

class SubSelfStatement(CommonAssignmentStatement):
    def get(self):
        self.source.set(self.source.get()-self.target.get())
        return self.source.get()

class SubStatement:    
    def get(self):
        return self.source.get() - self.target.get()

class MulSelfStatement(CommonAssignmentStatement):
    def get(self):
        self.source.set(self.source.get()*self.target.get())
        return self.source.get()

class MulStatement:
    def get(self):
        return self.source.get() * self.target.get()

class DivSelfStatement(CommonAssignmentStatement):
    def get(self):
        self.source.set(self.source.get()/self.target.get())
        return self.source.get()

class DivStatement:
    def get(self):
        return self.source.get() / self.target.get()

class ModSelfStatement(CommonAssignmentStatement):
    def get(self):
        self.source.set(self.source.get()%self.target.get())
        return self.source.get()

class ModStatement:
    def get(self):
        return self.source.get() % self.target.get()

class OrSelfStatement(CommonAssignmentStatement):
    def get(self):
        self.source.set(self.source.get() | self.target.get())
        return self.source.get()

class OrStatement:
    def get(self):
        return self.source.get() | self.target.get()

class AndSelfStatement(CommonAssignmentStatement):
    def get(self):
        self.source.set(self.source.get() & self.target.get())
        return self.source.get()

class AndStatement:
    def get(self):
        return self.source.get() & self.target.get()

class NandSelfStatement(CommonAssignmentStatement):
    def get(self):
        self.source.set((not self.source.get()) or (not self.target.get()))
        return self.source.get()

class NandStatement:
    def get(self):
        return (not self.source.get()) or (not self.target.get())

class BitOrSelfStatement(CommonAssignmentStatement):
    def get(self):
        self.source.set(self.source.get() or self.target.get()) 
        return self.source.get()

class BitOrStatement:
    def get(self):
        return self.source.get() or self.target.get()

class BitAndSelfStatement(CommonAssignmentStatement):
    def get(self):
        self.source.set(self.source.get() and self.target.get())
        return self.source.get()

class BitAndStatement:
    def get(self):
        return self.source.get() and self.target.get()

class IsLessStatement:
    def get(self):
        return self.source.get() < self.target.get()

class IsEqualStatement:
    def get(self):
        return self.source.get() == self.target.get()

class IsGreaterStatement:
    def get(self):
        return self.source.get() > self.target.get()

class IsLessOrEqualStatement:
    def get(self):
        return self.source.get() <= self.target.get()

class IsNotEqualStatement:
    def get(self):
        return self.source.get() != self.target.get()

class IsGreaterOrEqualStatement:
    def get(self):
        return self.source.get() >= self.target.get()

# -------------------------- SINGLE ARGUMENT FUNCTIONS ----------------------
# Convention: Argument is "value"

class LiteralStatement:
    def __init__(self,value=None):
        self.value = value

    def get(self):
        return self.value

class PrintCharStatement:
    def __init__(self,value = None):
        self.value = value
    
    def get(self):
        print chr(self.value.get()),
        return 1
    
class PrintStatement:
    def __init__(self,value = None):
        self.value = value
    
    def get(self):
        print self.value.get()
        return 1

class NegateStatement:
    def __init__(self,value=None):
        self.value = value

    def get(self):
        return not self.value.get()

# -------------------------- FUNCTIONS WITH ONE ARGUMENT ----------------------
# Convention: Code is "code", Argument is "args".

class IfStatement:
    def get(self):
        if args.get():
            return self.code.get()

class WhileDoStatement:
    def get(self):
        while self.args.get():
            self.code.get()

class UntilDoStatement:
    def get(self):
        while 1:
            self.args.get()
            if not self.code.get():
                break

# -------------------------- FUNCTIONS WITH TWO ARGUMENTS ----------------------
# Convention: Code is "code", First argument is "args", second argument is "more". 

class IfThenElseStatement:
    def get(self):
        if args.get():
            return self.code.get()
        else:
            return self.more.get()

class IfThenUnlessStatement:
    def get(self):
        if args.get() and not self.more.get():
            return self.code.get()

class IfThenProvidedStatement:
    def get(self):
        if args.get() and self.more.get():
            return self.code.get()

class WhileDoUnlessStatement:
    def get(self):
        while self.args.get() and not self.more.get():
            self.code.get()

class WhileDoElseStatement:
    def get(self):
        looped = 0
        while self.args.get():
            looped = 1
            self.code.get()
        if not looped:
            self.more.get()
            
class ForStatement:
    def get(self):
        for i in range(self.code.get()):
            self.args.set(i)
            self.more.get()


known = {
    PrintStatement : [ "value" ],
    PrintCharStatement : [ "value" ],
    NegateStatement : [ "value" ],
    IfStatement : [ "code", "args" ],
    WhileDoStatement : [ "code", "args" ],
    UntilDoStatement : [ "code", "args" ],
    IfThenElseStatement : [ "code", "args", "more" ],
    IfThenUnlessStatement : [ "code", "args", "more" ],
    IfThenProvidedStatement : [ "code", "args", "more" ],
    WhileDoUnlessStatement : [ "code", "args", "more" ],
    WhileDoElseStatement : [ "code", "args", "more" ],
    ForStatement : [ "code", "args", "more" ],
    AssignmentStatement : [ "source", "target" ],
    AddSelfStatement : [ "source", "target" ],
    AddStatement : [ "source", "target" ],
    SubSelfStatement : [ "source", "target" ],
    SubStatement : [ "source", "target" ],
    MulSelfStatement : [ "source", "target" ],
    MulStatement : [ "source", "target" ],
    DivSelfStatement : [ "source", "target" ],
    DivStatement : [ "source", "target" ],
    ModSelfStatement : [ "source", "target" ],
    ModStatement : [ "source", "target" ],
    OrSelfStatement : [ "source", "target" ],
    OrStatement : [ "source", "target" ],
    AndSelfStatement : [ "source", "target" ],
    AndStatement : [ "source", "target" ],
    NandSelfStatement : [ "source", "target" ],
    NandStatement : [ "source", "target" ],
    BitOrSelfStatement : [ "source", "target" ],
    BitOrStatement : [ "source", "target" ],
    BitAndSelfStatement : [ "source", "target" ],
    BitAndStatement : [ "source", "target" ],
    IsLessStatement : [ "source", "target" ],
    IsEqualStatement : [ "source", "target" ],
    IsGreaterStatement : [ "source", "target" ],
    IsLessOrEqualStatement : [ "source", "target" ],
    IsNotEqualStatement : [ "source", "target" ],
    IsGreaterOrEqualStatement : [ "source", "target" ]
}