import string, helpers, brackets

spaces = [' ','\t','\n']
 
class SPACE2001(brackets.Brackets):

    def __init__(self):
        self.reps = {}
        self.reps['>'] = "\t\t \t  \n"
        self.reps['+'] = "\t\t \t       \n \t"
        self.reps[','] = "\t\t \t \n\n "
        self.reps['/'] = "\t\t \t \n \t \n\n"
        self.reps['<'] = "\t\t \t                            "
        self.reps['-'] = "\t\t \t\n   \t\n\n\t  "
        self.reps['('] = "\t\t \t  \t"
        self.reps['='] = "\t\t \t \n "
        self.reps[')'] = "\t\t \t           \n     "
        self.reps['*'] = "\t\t \t    \t\n"
        brackets.Brackets.__init__(self)

    def AsString(self,x):
        result = ''
        for c in brackets.Brackets.AsString(self,x):
            if c in (' ','\n','\t'):
                pass
            elif c in self.reps.keys():
                result += self.reps[c]
            else:
                result += c
        return result        

    def parse(self,filename):
        bytes = open(filename).read()
        result = ""
        index, maxix = 0, len(bytes)
        while index < maxix:
        
            write_this_char = 1

            for key in '>+,/<-(=)*':
                x = self.reps[key]
                l = len(x)
                if bytes[index:index+l] == x:                    
                    result += key
                    write_this_char = 0
                    index += l
                    break
                
            if write_this_char:
                if bytes[index] == '\t':
                    result += '\\t'
                    print "???"
                elif bytes[index] == '\n':
                    result += '\\n'
                    print "???"
                elif bytes[index] == '\r':
                    print "???"
                else:
                    result += bytes[index]
                index += 1

        return self.parseString(result);                    

