import sys, easy, brackets, space2001, slashdot, yacuabll
import dotcolon, chef, statements, internal, gertrude

def extension(filename):
    index = filename.rfind('.')
    if index >= 0:
        return filename[index:].lower()
    return ""

def language(source):
    key = extension(source)

    if key == ".easy":
        return easy.Easy
    elif key == ".((o))":
        return brackets.Brackets
    elif key == ". ":
        return space2001.SPACE2001
    elif key == "./":
        return slashdot.Slashdot
    elif key == ".chef":
        return chef.Chef
    elif key == ".pickle":
        return internal.Internal
    elif key == ".:":
        return dotcolon.DotColon
    elif key == ".gertrude":
        return gertrude.Stein
    elif key == ".yacuabll":
        return yacuabll.Yacuabll
    return None

def help():
    print """
USAGE: gplz.py source [target] [{OPTIONS}]
OPTIONS:
    -d ..... will print the statements as they are being executed by the FBI.
    -w ..... will print a useless warning

Supported languages:

.easy, .((o)), ". ", ./, .chef, .pickle, .:, .getrude, .yacuabll

For more info, visit http://www.p-nand-q.com
"""

def main():
    global debugmode
    print "The Great Python-Language Zoo, Version 1.4"

    if (len(sys.argv) <= 1):
        return help()    

    source, target = None, None

    for i in range(1,len(sys.argv)):
        arg = sys.argv[i]
        if arg[:2] == '-d':
            statements.debugmode = 1
        elif arg[:2] == '-?':
            return help()
        elif arg[:2] == '-w':
            print 'Warning, the -w switch issues a useless warning and is depracated [if that word exists].'
        elif source is None:
            source = arg
        elif target is None:
            target = arg
        else:
            return help()
           
    input = language(source)

    if input is None:
        return help()
    
    if target is not None:
        output = language(target)
        if output is None:
            return help()
    else:
        output = None 

    parser = input()
    result = parser.parse(source)
    if result is not None:
        if output is None:
            print "Running", source
            result.get()
        else:
            print "Converting",source,"->",target
            output().DumpToFile(target,result)
    else:
        print "Unable to read", source

main()
