import string, helpers, brackets, os, stat, time, statements

def AddOrAppend(dict,key,object):
    if not dict.has_key(key):
        dict[key] = [object]
    else:
        dict[key].append(object)                    

class Stein:

    def __init__(self):
        self.instructions = {}
        self.instructions['6/3'] = statements.FuncDefStatement
        self.instructions['2/7'] = statements.FuncCallStatement
        #self.instructions['3/6'] = < Begin Block > => statements.StatementBlock
        #self.instructions['4/12'] = < End Block >
        self.instructions['16/15'] = statements.VariableStatement
        self.instructions['18/16'] = statements.AssignmentStatement
        self.instructions['10/20'] = statements.AddSelfStatement
        self.instructions['14/10'] = statements.AddStatement
        self.instructions['4/14'] = statements.SubSelfStatement
        self.instructions['11/7'] = statements.SubStatement
        self.instructions['23/14'] = statements.MulSelfStatement
        self.instructions['6/16'] = statements.MulStatement
        self.instructions['8/12'] = statements.DivSelfStatement
        self.instructions['5/8'] = statements.DivStatement
        self.instructions['14/8'] = statements.ModSelfStatement
        self.instructions['24/17'] = statements.ModStatement
        self.instructions['23/10'] = statements.OrSelfStatement
        self.instructions['22/23'] = statements.OrStatement
        self.instructions['19/22'] = statements.AndSelfStatement
        self.instructions['18/14'] = statements.AndStatement
        self.instructions['10/18'] = statements.NandSelfStatement
        self.instructions['15/15'] = statements.NandStatement
        self.instructions['14/12'] = statements.BitOrSelfStatement
        self.instructions['15/26'] = statements.BitOrStatement
        self.instructions['6/11'] = statements.BitAndSelfStatement
        self.instructions['17/11'] = statements.BitAndStatement
        self.instructions['15/19'] = statements.IsLessStatement
        self.instructions['18/15'] = statements.IsEqualStatement
        self.instructions['13/13'] = statements.IsGreaterStatement
        self.instructions['13/15'] = statements.IsLessOrEqualStatement
        self.instructions['15/14'] = statements.IsNotEqualStatement
        self.instructions['10/15'] = statements.IsGreaterOrEqualStatement
        self.instructions['3/1'] = statements.LiteralStatement
        self.instructions['7/14'] = statements.PrintCharStatement
        self.instructions['7/15'] = statements.PrintStatement
        self.instructions['23/20'] = statements.NegateStatement
        self.instructions['6/10'] = statements.IfStatement
        self.instructions['20/18'] = statements.WhileDoStatement
        self.instructions['14/20'] = statements.UntilDoStatement
        self.instructions['12/12'] = statements.IfThenElseStatement
        self.instructions['10/19'] = statements.IfThenUnlessStatement
        self.instructions['1/6'] = statements.IfThenProvidedStatement
        self.instructions['25/15'] = statements.WhileDoUnlessStatement

    def DumpToFile(self,target,result):
        print ".Getrude does not want not"
        return None

    def parse(self,filename):
        result = []
        sentence = ""   
        for line in open(filename).readlines():
            if line[:8] == "        ":
                line = line[8:]
            line = line.strip()
            while len(line):
                index = line.find('.')
                if index >= 0:
                    sentence += line[:index+1] + " "
                    line = line[index+1:]
                    sentence = filter(lambda x: x !="" ,sentence.split(' '))
                    if len(sentence):
                        total, count = 0, len(sentence)
                        for i in range(count):
                            word = sentence[i]
                            index = word.find('.')
                            if index >= 0:
                                word = word[:index]
                            index = word.find(',')
                            if index >= 0:
                                word = word[:index]
                            sentence[i] = word
                            total += len(word)                
                        average = total / count
                        less, more = 0, 0
                        for word in sentence:
                            l = len(word)
                            if l < average:
                                less += 1
                            elif l > average:
                                more += 1
                        ratio = "%d/%d" % (less,more)
                        if less:
                            intval = int(float(more)/float(less))
                        else:
                            intval = 0
                        result.append( [ratio, intval] )
                    sentence = ""
                else:
                    sentence += line + " "
                    break
        repeat = 1        
        while repeat:
            repeat = 0
            for i in range(len(result)):
                object = result[i]
                if type(object) != type([]):
                    break_loop = 0
                    for classname in statements.known.keys():
                        if isinstance(object,classname):
                            for attribute in statements.known[classname]:
                                if getattr(object,attribute) is None:
                                    if type(result[i+1]) == type([]):
                                        repeat = 1
                                    else:
                                        setattr(result[i],attribute,result[i+1])
                                        result = result[:i+1] + result[i+2:]
                                        break_loop = 1
                                    repeat = 1
                                    break
                            break
                    if break_loop:
                        break
                    continue                                       
                key = object[0]
                if self.instructions.has_key(key):
                    result[i] = self.instructions[key]()
                    if isinstance(result[i],statements.VariableStatement):
                        result[i].setname( "Var%d" % result[i+1][1] )
                        result = result[:i+1] + result[i+2:]
                        repeat = 1
                        break
                    elif isinstance(result[i],statements.LiteralStatement):
                        result[i].value = result[i+1][1]
                        result = result[:i+1] + result[i+2:]
                        repeat = 1
                        break
        return statements.StatementBlock(result)
    