import string, statements, re

class GenericParser:

    def __init__(self):
        self.debug = 0
        self.tabs = 0

    def DEBUG(self,message):
        if self.debug:
            print '  '*self.tabs + message + " AT '" + self.str[self.pos:] +"'"

    def AsString(self,x):
        return self.dump(x)
            
    def peek(self):
        if self.pos in range(0,len(self.str)):
            return self.str[self.pos]
        return chr(0)

    def DumpToFile(self,target,result):
        file = open(target,"w")
        file.write(self.AsString(result))
        file.close()

    def skipwhitespaces(self):
        while self.str[self.pos] in (' ','\t','\n'):
            self.DEBUG("SKIPPING WS")
            self.pos += 1
    
    def skip(self,x):
        if self.str[self.pos:self.pos+len(x)]==x:
            self.DEBUG("SKIPPING "+x)
            self.pos+=len(x)
            
            return 1
        return 0

    def oneof(self,*options):
        pos = self.pos
        for i in options:
            result = i()
            if result is not None: return result
        self.pos = pos
        return None

    def NAME(self):
        self.DEBUG("NAME BEGIN")
        self.tabs+=1
        start = self.pos
        if self.peek() in string.letters:
            self.pos += 1
            while 1:
                c = self.peek()
                if c in string.letters or c in string.digits:
                    self.pos += 1
                else: break
            result = self.str[start:self.pos]
            self.tabs-=1
            self.DEBUG("NAME RETURNS "+result)
            return result

        self.tabs-=1
        self.DEBUG("NAME FAILS")
        self.pos = start
        return None

    def VARIABLE(self):
        n = self.NAME()
        if n is not None:
            return statements.VariableStatement(n)
        return None

    def LITERAL(self):
        self.DEBUG("LITERAL BEGIN")
        self.tabs+=1

        result = 0
        pos = self.pos
        if self.str[self.pos] in ['"',"'"]:
            ec = self.str[self.pos]
            self.pos += 1
            start = self.pos
            stop = self.str[self.pos:]
            stopix = stop.find(ec)
            if stopix >= 0:
                result = self.str[start:start+stopix]
                self.pos = stopix+1
                result = statements.LiteralStatement(result)
                self.tabs-=1
                self.DEBUG("LITERAL '"+str(result)+"' FOUND")
                return result
                
                
        elif self.str[self.pos] in string.digits:
            result = ord(self.str[self.pos])-ord('0')
            self.pos += 1           
            while self.peek() in string.digits:
                result = result*10 + ord(self.str[self.pos])-ord('0')
                self.pos += 1
            result = statements.LiteralStatement(result)
            self.tabs-=1
            self.DEBUG("LITERAL "+str(result)+" FOUND")
            return result            
        self.tabs-=1
        self.DEBUG("LITERAL FAILS")
        self.pos = pos 
        return None
    