import string, helpers, brackets, os, stat

def basename(filename):
    index = filename.rfind('.')
    if index >= 0:
        return filename[:index]
    return filename


def dir2string(dir):
    for f in os.listdir(dir):
        pathname = '%s\\%s' % (dir, f)
        if stat.S_ISDIR(os.stat(pathname)[stat.ST_MODE]):
            return dir2string(pathname)
    return dir

class Slashdot(brackets.Brackets):

    def __init__(self):
        brackets.Brackets.__init__(self)
        self.reps = {}
        self.reps['>'] = "@"
        self.reps['/'] = "~"
        self.reps['\n'] = "_"
        self.reps[' '] = "_"
        self.reps['\t'] = "_"
        self.reps['<'] = "'"
        self.reps['*'] = '"'

        self.reversemap = {}
        for key in self.reps.keys():
            self.reversemap[self.reps[key]] = key

    def CreateDirectoryStructure(self,basedir,part):
        result = []
        for i in range(len(part)):
            if part[i] in self.reps.keys():
                part[i] = self.reps[part[i]]
            if len(result):
                result.append('\\')
            result.append(part[i])
        part = os.path.join(basedir,str(self.index),string.join(result,''))
        self.index += 1
        try:
            os.makedirs(part)
        except:
            print "ERROR, Unable to fully create \"%s\"" % part
        return part

    def DumpToFile(self,target,result):
        basedir = basename(target)
        outputfile = open("makedirs.cmd","w")
        expression = brackets.Brackets.AsString(self,result)
        self.index = 0
        while len(expression) > 10:
            outputfile.write("mkdir %s\n" % self.CreateDirectoryStructure(basedir,list(expression[:10])))
            expression = expression[10:]
        outputfile.write("mkdir %s\n" % self.CreateDirectoryStructure(basedir,expression))
        outputfile.close()

    def parse(self,filename):
        basedir = basename(filename)
        files = []
        for file in os.listdir(basedir):
            try:
                files.append(int(file))
            except:
                digit = 1
        files.sort()
        result = ""
        for file in files:
            subdir = "%s\\%d" % (basedir,file)
            part = dir2string(subdir).split('\\')
            part = part[2:]
            for i in range(len(part)):
                if part[i] in self.reversemap.keys():
                    part[i] = self.reversemap[part[i]]
            result += string.join(part,'')  
        return brackets.Brackets.parseString(self,result)

