import string, helpers, brackets, os, stat, time, statements

def basename(filename):
    index = filename.rfind('.')
    if index:
        return filename[:index]
    return filename

def stricmp(x,y):
    i = 0
    while 1:
        cx, cy = 0, 0
        if i < len(x):
            cx = ord(x[i].lower())
        if i < len(y):
            cy = ord(y[i].lower())
        if cx != cy:
            return cx-cy
        if cx == 0:
            return 0
        i += 1

def comparefunc(x,y):
    return stricmp(x[1],y[1])
    
class DotColon(brackets.Brackets):

    def __init__(self):
        self.dual_operators = {}
        self.dual_operators["="] = statements.IsEqualStatement
        self.dual_operators[" ="] = statements.IsLessStatement
        self.dual_operators["+="] = statements.AddSelfStatement
        self.dual_operators["-="] = statements.SubSelfStatement
        self.dual_operators["_="] = statements.MulSelfStatement
        self.dual_operators[".="] = statements.DivSelfStatement
        self.dual_operators["apfelstrudel="] = statements.NandSelfStatement
        self.dual_operators["="]  = statements.AssignmentStatement
        self.dual_operators["+"] = statements.AddStatement
        self.dual_operators["-"] = statements.SubStatement
        self.dual_operators["_"] = statements.MulStatement
        self.dual_operators["."] = statements.DivStatement
        self.dual_operators["apfelstrudel"] = statements.NandStatement

        self.single_op_functions = {}
        self.single_op_functions["kurt"] = statements.WhileDoStatement
        self.single_op_functions["eiffelturm"] = statements.IfStatement
        self.single_op_functions["niemals!"] = statements.UntilDoStatement

        self.dual_op_functions = {}
        self.dual_op_functions["seltsam"] = statements.IfThenElseStatement
        self.dual_op_functions["sonderbar"] = statements.IfThenUnlessStatement
        self.dual_op_functions["sinnlos"] = statements.IfThenProvidedStatement
        self.dual_op_functions["nutzlos"] = statements.WhileDoUnlessStatement

        brackets.Brackets.__init__(self)        

    def DumpToFile(self,target,result):
        print ".: currently does not support this action.!"

    def WalkTree( self, dir ):
        list = []
        for f in os.listdir(dir):
            pathname = os.path.join(dir, f)
            s = os.stat(pathname)
            mode = s[stat.ST_MODE]
            if stat.S_ISDIR(mode):
                list.append([1,f.lower()])
            elif stat.S_ISREG(mode):
                variable = self.GetVariable(pathname,s)
                if variable is not None:
                    list.append([0,f.lower(),variable])
        list.sort(comparefunc)
        for i in range(len(list)):
            object = list[i]
            if object[0]:
                object.append(self.WalkTree(os.path.join(dir,object[1])))

            ix = object[1].rfind('.')
            if ix >= 0:
                object[1] = object[1][ix+1:]

            if object[0]:
                if object[1] == "print":
                    list[i] = statements.PrintStatement(object[2][0])
                    object = None
                elif object[1] in self.single_op_functions.keys():
                    list[i] = self.single_op_functions[object[1]]()
                    list[i].args = object[2][0]
                    list[i].code = statements.StatementBlock(object[2][1:])                   
                    object = None
                elif object[1] in self.dual_op_functions.keys():
                    list[i] = self.dual_op_functions[object[1]]()
                    list[i].args = object[2][0]
                    list[i].code = statements.StatementBlock(object[2][1:-1])
                    list[i].more = statements.StatementBlock(object[2][-1])
                    object = None
                elif object[1] in self.dual_operators.keys():
                    list[i] = self.dual_operators[object[1]]()
                    list[i].source = object[2][0]
                    list[i].target = object[2][1]
                elif object[2] == []:
                    list[i] = statements.VariableStatement(object[1])
                else:
                    print "UNKNOWN OBJECT \"%s\",ABORTING" % object[1]
            else:
                list[i] = statements.VariableStatement(object[1],object[2])
                object = None

        return list

    def GetVariable(self, pathname, s):
        year = time.localtime(s[stat.ST_MTIME])[0]
        if year == 1992:
            return open(pathname).read()                    
        elif year == 1991:
            return s[stat.ST_SIZE]
        return None
                
    def parse(self,filename):
        self.result = self.WalkTree( basename(filename) )
        if self.result is not None:
            return statements.StatementBlock(self.result)
