import string, helpers, genericparser, statements

ingredients = []
mixing_bowls = {}
baking_dishes = {}
recipies = {}
last_used_mixing_bowl = 0

def GetIngredient(name):
    global ingredients
    for i in ingredients:
        if i['name'] == name:
            return i['value']
    raise "Unknown ingredient %s" % name

def SetIngredient(name,value):
    global ingredients
    for i in ingredients:
        if i['name'] == name:
            i['value'] = value
            return

def PushMixingBowl(i,n):
    global mixing_bowls, last_used_mixing_bowl
    if not mixing_bowls.has_key(n):
        mixing_bowls[n] = []
    mixing_bowls[n].insert(0,i)
    last_used_mixing_bowl = n

def PopMixingBowl(n):
    global mixing_bowls, last_used_mixing_bowl
    if not mixing_bowls.has_key(n):
        mixing_bowls[n] = []
    
    if len(mixing_bowls[n]):
        result = mixing_bowls[n][0]
        mixing_bowls[n] = mixing_bowls[n][1:]        
    else:
        mixing_bowls[n] = []
        result = 0
    last_used_mixing_bowl = n
    return result
    
class ChefMethod:
    def __init__(self,method):
        self.method = method

class AnyMethod(ChefMethod):
    def get(self):
        pass

class PutMethod(ChefMethod):
    '''This puts the ingredient into the nth mixing bowl.'''
    def get(self):
        PushMixingBowl(GetIngredient(self.method[0]),self.method[1])

class FoldMethod(ChefMethod):
    '''This removes the top value from the nth mixing bowl and places it in the ingredient.'''
    def get(self):       
        SetIngredient(self.method[0],PopMixingBowl(self.method[1]))

class AddMethod(ChefMethod):
    '''This adds the value of ingredient to the value of the ingredient on top
of the nth mixing bowl and stores the result in the nth mixing bowl.'''
    def get(self):
        global last_used_mixing_bowl
        if len(self.method) == 1:
            i = PopMixingBowl(last_used_mixing_bowl)
        else:
            i = PopMixingBowl(self.method[1])
        j = GetIngredient(self.method[0])
        i += j
        PushMixingBowl(i,last_used_mixing_bowl)

class RemoveMethod(ChefMethod):
    '''This subtracts the value of ingredient from the value of the ingredient on top
of the nth mixing bowl and stores the result in the nth mixing bowl.'''
    def get(self):
        global last_used_mixing_bowl
        if len(self.method) == 1:
            i = PopMixingBowl(last_used_mixing_bowl)
        else:
            i = PopMixingBowl(self.method[1])
        j = GetIngredient(self.method[0])
        i -= j
        PushMixingBowl(i,last_used_mixing_bowl)

class CombineMethod(ChefMethod):
    '''This multiplies the value of ingredient by the value of the ingredient on top of
    the nth mixing bowl and stores the result in the nth mixing bowl.'''
    def get(self):
        global last_used_mixing_bowl
        if len(self.method) == 1:
            i = PopMixingBowl(last_used_mixing_bowl)
        else:
            i = PopMixingBowl(self.method[1])
        j = GetIngredient(self.method[0])
        i *= j
        PushMixingBowl(i,last_used_mixing_bowl)        

class DivideMethod(ChefMethod):
    '''This divides the value of ingredient by the value of the ingredient on top of
    the nth mixing bowl and stores the result in the nth mixing bowl.'''
    def get(self):
        global last_used_mixing_bowl
        if len(self.method) == 1:
            i = PopMixingBowl(last_used_mixing_bowl)
        else:
            i = PopMixingBowl(self.method[1])
        j = GetIngredient(self.method[0])
        i /= j
        PushMixingBowl(i,last_used_mixing_bowl)

class AddDryMethod(ChefMethod):
    '''This adds the values of all the dry ingredients together and places the result into the nth mixing bowl.'''
    def get(self):
        global last_used_mixing_bowl
        if len(self.method) != 1:
            last_used_mixing_bowl = self.method[1]
        t = None
        for i in ingredients:
            if i['type'] == 'dry':
                if t is None:
                    t = i
                else:
                    t['value'] += i['value']
        if t is not None:
            PushMixingBowl(t,last_used_mixing_bowl)

class LiquifyContentsMethod(ChefMethod):
    '''This turns all the ingredients in the nth mixing bowl into a liquid, i.e. a Unicode characters for output purposes.'''
    def get(self):
        global mixing_bowls
        m = mixing_bowls[self.method[0]]
        for i in range(len(m)):
            m[i] = chr(m[i])

class LiquifyMethod(ChefMethod):
    '''This turns the ingredient into a liquid, i.e. a Unicode character for output purposes.'''
    def get(self):
        global mixing_bowls
        m = mixing_bowls[self.method[0]]
        for i in range(len(m)):
            print str(m[i])
            
class StirForMinutesMethod(ChefMethod):
    '''This rolls the number of ingredients in the nth mixing bowl equal to the value of
    ingredient, such that the top ingredient goes down that number of ingredients and all
    ingredients above it rise one place. If there are not that many ingredients in the bowl,
    the top ingredient goes to be bottom of the bowl and all the others rise one place'''
    def get(self):
        global mixing_bowls, last_used_mixing_bowl
        if len(self.method) == 1:
            n, c = last_used_mixing_bowl, self.method[0]
        else:
            n, c = self.method[0], self.method[1]

        if not mixing_bowls.has_key(n):
            mixing_bowls[n] = []
        m = mixing_bowls[n]
        i = PopMixingBowl(n)
        if c > len(m):
            c = len(m)
        m.insert(c,i)

class StirIntoMethod(ChefMethod):
    '''This rolls the number of ingredients in the nth mixing bowl equal to the
    value of ingredient, such that the top ingredient goes down that number of
    ingredients and all ingredients above it rise one place. If there are not
    that many ingredients in the bowl, the top ingredient goes to tbe bottom of
    the bowl and all the others rise one place.'''     
    def get(self):
        print "*** not implemented yet ***"

class MixMethod(ChefMethod):
    '''This randomises the order of the ingredients in the nth mixing bowl.'''
    def get(self):
        # the randomize function used by this method is severly broken :)
        pass

class CleanMethod(ChefMethod):
    '''This removes all the ingredients from the nth mixing bowl.'''
    def get(self):
        global mixing_bowls
        mixing_bowls[self.method[0]] = []

class PourMethod(ChefMethod):
    '''This copies all the ingredients from the nth mixing bowl to the pth baking dish,
    retaining the order and putting them on top of anything already in the baking dish. '''
    def get(self):
        global mixing_bowls, baking_dishes
        source = mixing_bowls[self.method[0]]
        if not baking_dishes.has_key(self.method[1]):
            baking_dishes[self.method[1]] = []
        baking_dishes[self.method[1]] = baking_dishes[self.method[1]] + source     

class PourBowlMethod(ChefMethod):
    '''This copies all the ingredients from the nth mixing bowl to the pth baking dish,
    retaining the order and putting them on top of anything already in the baking dish. '''
    def get(self):
        global mixing_bowls
        source = mixing_bowls[self.method[0]]
        if not mixing_bowls.has_key(self.method[1]):
            mixing_bowls[self.method[1]] = []
        mixing_bowls[self.method[1]] = mixing_bowls[self.method[1]] + source     

class ServesMethod(ChefMethod):
    def get(self):
        global baking_dishes
        print string.join(baking_dishes[int(self.method[0])],'')

class ServeWithMethod(ChefMethod):
    def get(self):
        global baking_dishes
        result = 0
        loops = [-1]
        statements = recipies[self.method[0]]
        i, imax = 0, len(statements)
        
        while i < imax:            
            stmt = statements[i]
            
            # execute statement
            if loops[0] is None:
                result = 1
            else:
                result = stmt.get()

            # if this is the start of a loop    
            if isinstance(stmt,VerbMethod):
                if result:
                    loops.insert(0,i)
                else:
                    loops.insert(0,None) # indicates that this loop is to be skipped
                i += 1

            # if this is the stop of a loop
            elif isinstance(stmt,VerbUntilMethod):
                if loops[0] is None:
                    loops = [-1]
                elif loops[0] != -1:
                    i = loops[0]
                else:
                    i += 1
            else:
                i += 1
        return result



class RefrigerateMethod(ChefMethod):    
    def get(self):
        pass

class VerbMethod(ChefMethod):
    '''This marks the beginning of a loop. It must appear as a matched pair with the
    following statement. The loop executes as follows:
    The value of ingredient is checked. If it is non-zero,
    the body of the loop executes until it reaches the "until" statement.
    The value of ingredient is rechecked.
    If it is non-zero, the loop executes again.
    If at any check the value of ingredient is zero, the loop exits and
    execution continues at the statement after the "until". Loops may be nested'''
    def get(self):
        return GetIngredient(self.method[0])

class VerbUntilMethod(ChefMethod):
    '''This marks the end of a loop. It must appear as a matched pair with the above statement.
    verbed must match the Verb in the matching loop start statement.
    The Verb in this statement may be arbitrary and is ignored.
    If the ingredient appears in this statement, its value is decremented by 1
    when this statement executes. The ingredient does not have to match the ingredient
    in the matching loop start statement.'''
    def get(self):
        pass

class SetAsideMethod(ChefMethod):    
    def get(self):
        pass
        
class Chef(genericparser.GenericParser):

    def __init__(self):
        self.dry_measures = ['g','kg','pinch','pinches']
        self.liquid_measures = ['ml','l','dash','dashes']
        self.other_measures = ['cup','cups','teaspoon','teaspoons','tablespoon','tablespoons']

        self.methods = []
        self.classes = []
        
        self.methods.append( 'Put $I into $N mixing bowl' )
        self.classes.append( PutMethod )
        
        self.methods.append( 'Fold $I into $N mixing bowl' )
        self.classes.append( FoldMethod )
        
        self.methods.append( 'Add $I [ to $N mixing bowl ]' )
        self.classes.append( AddMethod )
        
        self.methods.append( 'Remove $I [ from $N mixing bowl ]' )
        self.classes.append( RemoveMethod )
        
        self.methods.append( 'Combine $I [ into $N mixing bowl ]' )
        self.classes.append( CombineMethod )
        
        self.methods.append( 'Divide $I [ into $N mixing bowl ]' )
        self.classes.append( DivideMethod )
        
        self.methods.append( 'Add dry $I [ to $N mixing bowl ]' )
        self.classes.append( AddDryMethod )
        
        self.methods.append( 'Liquify contents of the $N mixing bowl' )
        self.classes.append( LiquifyContentsMethod )
        
        self.methods.append( 'Liquify the $N mixing bowl' )
        self.classes.append( LiquifyMethod )
        
        self.methods.append( 'Stir [ the $N mixing bowl ] for $N minutes' )
        self.classes.append( StirForMinutesMethod )
        
        self.methods.append( 'Stir $I into the $N mixing bowl' )
        self.classes.append( StirIntoMethod )
        
        self.methods.append( 'Mix [ the $N mixing bowl ] well' )
        self.classes.append( MixMethod )
        
        self.methods.append( 'Clean $N mixing bowl' )
        self.classes.append( CleanMethod )
        
        self.methods.append( 'Pour contents of the $N mixing bowl into the $N baking dish' )
        self.classes.append( PourMethod )

        self.methods.append( 'Pour contents of the $N mixing bowl into the $N mixing bowl' )
        self.classes.append( PourBowlMethod )
        
        self.methods.append( 'Verb [ the $I ] until [ verbed ]' )
        self.classes.append( VerbUntilMethod )

        self.methods.append( 'Verb the $I' )
        self.classes.append( VerbMethod )
        
        self.methods.append( 'Set aside' )
        self.classes.append( SetAsideMethod )
        
        self.methods.append( 'Serve with $I' )
        self.classes.append( ServeWithMethod )

        self.methods.append( 'Refrigerate [ for $N hours ]' )
        self.classes.append( RefrigerateMethod )
        
        self.methods.append( 'Serves $I' )
        self.classes.append( ServesMethod )

        for i in range(len(self.methods)):
            self.methods[i] = self.methods[i].split(' ')

        genericparser.GenericParser.__init__(self)

    def AsString(self,x):
        result = ''
        return result

    def match_method(self,method,b):
        j = 0
        result = []
        optional = 0
        for i in range(len(method)):
            m = method[i]
            if m == '[':
                optional = 1
                if (j==len(b)) and (method[-1] == ']'):
                    break
                if method[i+1] == b[j]:
                    optional = 0
            elif m == ']':
                optional = 0
            elif not optional:
                if m == '$I':
                    next = method[i+1]
                    if next == '[':
                        next = method[i+2]
                    if len(method) == i+1:
                        result.append(string.join(b[j:],' '))
                        break
                    s = j
                    while (j<len(b)) and (b[j] != next):
                        j += 1
                    result.append(string.join(b[s:j],' '))
                elif m == '$N':
                    s = j                   
                    next = method[i+1]
                    if next == '[':
                        next = method[i+2]

                    while (j<len(b)) and (b[j] != next):
                        j += 1
                    content = string.join(b[s:j],' ')
                    if (s == j) or (content == 'the'):
                        result.append(1)
                    else:
                        while content[0] not in string.digits:
                            content = content[1:]
                        try:
                            result.append(int(content))
                        except:
                            return None
                elif (j<len(b)) and (b[j] == m):
                    j += 1
                else:
                    return None
        return result

    def method(self,x):
        x = x.split(' ')
        for i in range(len(self.methods)):
            result = self.match_method(self.methods[i],x)
            if result is not None:
                if self.classes[i] is not None:
                    return self.classes[i](result)
                print "ERROR, no class for method:", x
                return None
        if 'until' in x:
            return VerbUntilMethod(x)
        if x[1] == 'the':
            x = [string.join(x[2:],' ')]
        else:
            x = [string.join(x[1:],' ')]
        return VerbMethod(x)

    def ingredient(self,x):
        temp = x.split(' ')
        if len(temp) < 2:
            return None
        result = {}
        result['value'] = int(temp[0])       
        temp = temp[1:]
        if temp[0] in ('heaped','level'):
            result['type']='dry'
            temp = temp[1:]
        if temp[0] in self.dry_measures:
            result['measure']=temp[0]
            result['type']='dry'
            temp = temp[1:]
        elif temp[0] in self.liquid_measures:
            result['measure']=temp[0]
            result['type']='liquid'
            temp = temp[1:]
        elif temp[0] in self.other_measures:
            result['measure']=temp[0]
            result['type']='other'
            temp = temp[1:]
        result['name'] = string.join(temp,' ')
        return result

    def parse(self,filename):
        global ingredients, recipies
        mode = None
        result = "default"
        recipies["default"] = []
        for line in open(filename).readlines():
            if line[-1] == '\n':
                line = line[:-1]
            if line in ("Ingredients.","Method."):
                mode = line            
            elif mode == "Ingredients.":
                if helpers.strncmp(line,'Cooking time:') or helpers.strncmp(line,'Pre-heat'):
                    mode = None
                elif line != '':
                    i = self.ingredient(line)
                    if i:
                        ingredients.append( i )
            elif mode == "Method.":
                methods = line.split('.')
                for m in methods:
                    m = m.strip()
                    if m != '':
                        r = self.method(m)
                        if r is None:
                            print '>> Unable to parse "%s"' % m
                            return None
                        recipies[result].append(r)
                        if helpers.strncmp(str(r),"<chef.ServesMethod"):
                            result, mode = None, None
            elif (result is None) and (line != ''):
                result = line.strip()
                if result[-1] == '.':
                    result = result[:-1].lower()
                recipies[result] = []

        return ServeWithMethod(['default'])
        #return statements.StatementBlock(recipies["default"])

