#!/usr/bin/python

import sys, os

""" brainfuck.NET - a brainfuck compiler targeting .NETs MSIL

Written by Gerson Kurz (http://p-nand-q.com) in PYTHON, the best programming language of the world.
Released as Freeware. Enjoy!

The Brainfuck programming language consists of eight commands, each of
which is represented as a single character. 

>  Increment the pointer. 
<  Decrement the pointer. 
+  Increment the byte at the pointer. 
-  Decrement the byte at the pointer. 
.  Output the byte at the pointer. 
,  Input a byte and store it in the byte at the pointer. 
[  Jump to the matching ] if the byte at the pointer is zero. 
]  Jump to the matching [. 

"""

__VERSION__ = "1.0"

def ChangeExtension(filename,extension):
    index = filename.rfind(".")
    if index >= 0:
        return filename[:index] + extension
    return filename + extension

class BrainfuckNET:
    def __init__(self):
        self.while_level = 0
        self.while_stack= []
        self.instructions = {
            '>' : self.IncrementPointer,
            '<' : self.DecrementPointer,
            '+' : self.IncrementData,
            '-' : self.DecrementData,
            '.' : self.OutputData,
            ',' : self.InputData,
            '[' : self.WhileBegin,
            ']' : self.WhileEnd
        }
        self.keywords = self.instructions.keys()

    def compile(self,input,output):
        "This function compiles a BRAINFUCK sourcecode."

        # read source file 
        data = open(input).read()

        # open the output file
        output = ChangeExtension(output,".il")
        self.output = open(output,"w")
        print >>self.output, """// brainfuck.NET

.assembly extern mscorlib
{
  .publickeytoken = (B7 7A 5C 56 19 34 E0 89 )
  .hash = ( 98 31 71 95 B3 A4 51 E8 E2 0D 25 55 57 E7 6E 9E 54 8C EF C9 )
  .ver 1:0:3300:0
}
.assembly extern Microsoft.VisualC
{
  .publickeytoken = (B0 3F 5F 7F 11 D5 0A 3A ) 
  .hash = ( EC 47 1C 7B E2 10 BB EE 15 E2 3B 4E FB 55 44 9D E2 D0 4D B7 )
  .ver 7:0:3300:0
}
.assembly brainfuck
{
}
.class private explicit ansi sealed $ArrayType$putchar
       extends [mscorlib]System.ValueType
{
  .pack 1
  .size 2
  .custom instance void [Microsoft.VisualC]Microsoft.VisualC.DebugInfoInPDBAttribute::.ctor() = ( 01 00 00 00 ) 
}
.class private explicit ansi sealed $ArrayType$array
       extends [mscorlib]System.ValueType
{
  .pack 1
  .size 39996
  .custom instance void [Microsoft.VisualC]Microsoft.VisualC.DebugInfoInPDBAttribute::.ctor() = ( 01 00 00 00 ) 
}

.method public static int32 modopt([mscorlib]System.Runtime.CompilerServices.CallConvCdecl) 
        main() cil managed
{
  .vtentry 1 : 1
  
  .entrypoint
  .maxstack  4
  .locals (int32 V_p,
           valuetype $ArrayType$array V_array,
           valuetype $ArrayType$putchar V_putchar)

    // startup code
    ldc.i4.0 
    stloc.0
    ldloca.s   V_putchar
    ldc.i4.0
    stind.i1
    ldloca.s   V_putchar
    ldc.i4.1
    add
    ldc.i4.0
    stind.i1
"""
        # compile it using a bit of Python magic ;)        
        map(lambda x:self.instructions[x](),filter(lambda x: x in self.keywords, list(data)))

        # finish
        print >>self.output, "    ldc.i4.0" # load constant 0
        print >>self.output, "    ret" # done
        print >>self.output, "}"
        self.output.close()

        os.popen("ilasm "+output).read()

    def IncrementPointer(self):
        print >>self.output, "    ldloc.0" # load local variable p
        print >>self.output, "    ldc.i4.1" # load constant 1
        print >>self.output, "    add" # add
        print >>self.output, "    stloc.0" # store local variable p

    def DecrementPointer(self):
        print >>self.output, "    ldloc.0" # load local variable p
        print >>self.output, "    ldc.i4.1" # load constant 1
        print >>self.output, "    sub" # sub
        print >>self.output, "    stloc.0" # store local variable p

    def IncrementData(self):
        for i in range(2): # I have no idea why this has to be done twice, perhaps because of the way ldind works???
            print >>self.output, "    ldloca.s   V_array" # load address of array
            print >>self.output, "    ldloc.0" # load local variable p
            print >>self.output, "    ldc.i4.4" # load constant 4
            print >>self.output, "    mul" #  multiply (to get byte offset)
            print >>self.output, "    add" # add (to get array address)
        print >>self.output, "    ldind.i4" # load indirect 4 bytes
        print >>self.output, "    ldc.i4.1" # load constant 1
        print >>self.output, "    add" # add
        print >>self.output, "    stind.i4" # store indirect 4 bytes

    def DecrementData(self):
        for i in range(2): # I have no idea why this has to be done twice, perhaps because of the way ldind works???
            print >>self.output, "    ldloca.s   V_array" # load address of array
            print >>self.output, "    ldloc.0" # load local variable p
            print >>self.output, "    ldc.i4.4" # load constant 4
            print >>self.output, "    mul" # multiply (to get byte offset)
            print >>self.output, "    add" # add (to get array address)
        print >>self.output, "    ldind.i4" # load indirect 4 bytes
        print >>self.output, "    ldc.i4.1" # load constant 1
        print >>self.output, "    sub" # sub
        print >>self.output, "    stind.i4" # store indirect 4 bytes

    def OutputData(self):
        print >>self.output, "    ldloca.s   V_putchar" # load address of char array
        print >>self.output, "    ldloca.s   V_array" # load address of int array
        print >>self.output, "    ldloc.0" # load local variable p
        print >>self.output, "    ldc.i4.4" # load constant 4
        print >>self.output, "    mul" # multiply (to get byte offset)
        print >>self.output, "    add" # add (to get array address)
        print >>self.output, "    ldind.i4" # load indirect 4 bytes
        print >>self.output, "    stind.i1" # store indirect 4 bytes (Guess, my assumption above was correct then ;)
        print >>self.output, "    ldloca.s   V_putchar" # load address of putchar array
        print >>self.output, "    newobj     instance void [mscorlib]System.String::.ctor(int8*)" # create string
        print >>self.output, "    call       void [mscorlib]System.Console::Write(string)" # print it

    def InputData(self):
        print >>self.output, "    ldloca.s   V_putchar" # load address of char array
        print >>self.output, "    ldc.i4.1" # load constant 1
        print >>self.output, "    add" # add  ???
        print >>self.output, "    ldc.i4.0" # load constant 0
        print >>self.output, "    stind.i1" # store 1 byte indirect
        print >>self.output, "    ldloca.s   V_putchar" # load address of char array
        print >>self.output, "    call       int32 [mscorlib]System.Console::Read()" # call READ()
        print >>self.output, "    stind.i1" # store indirect
        print >>self.output, "    ldloca.s   V_array" # load address of int array
        print >>self.output, "    ldloc.0" # load local variable p
        print >>self.output, "    ldc.i4.4" # load constant 4
        print >>self.output, "    mul" # multiply (to get byte offset)
        print >>self.output, "    add" # add (to get array address)
        print >>self.output, "    ldloca.s   V_putchar" # load address of char array
        print >>self.output, "    ldind.i1" # load indirect 1 byte
        print >>self.output, "    stind.i4" # store indirect as 4 byte
  
    def WhileBegin( self ):
        self.while_stack.append(self.while_level)
        print >>self.output, "WHILE_%d_BEGIN:"  % self.while_level #
        print >>self.output, "    ldloca.s V_array" # load adress of int array
        print >>self.output, "    ldloc.0" # load local variable p
        print >>self.output, "    ldc.i4.4" # m
        print >>self.output, "    mul" # multiply (to get byte offset)
        print >>self.output, "    add" # add (to get array address)
        print >>self.output, "    ldind.i4" # load indirect 4 bytes
        print >>self.output, "    brfalse WHILE_%d_DONE"  % self.while_level # branch to end-of-loop if false
        self.while_level += 1

    def WhileEnd(self):
        l = self.while_stack[-1]
        self.while_stack = self.while_stack[:-1]
        print >>self.output, "    br WHILE_%d_BEGIN" % l
        print >>self.output, "WHILE_%d_DONE:" % l

if __name__ == "__main__":
    if len(sys.argv) == 3:
        compiler = BrainfuckNET()
        compiler.compile(sys.argv[1],sys.argv[2])
    else:
        print "USAGE: brainfuck.net.py <source> <target>"
