import win32serviceutil, win32service, threading, win32event, sys, pop3filter, sys

class ServerThread(threading.Thread):
    def __init__(self,callback):
        threading.Thread.__init__(self)
        self.callback = callback

    def run(self):
        self.callback()

class pop3filterService(win32serviceutil.ServiceFramework):
    _svc_name_ = "pop3filter"
    _svc_display_name_ = "POP3 Filter Service"
    
    def __init__(self, args):
        win32serviceutil.ServiceFramework.__init__(self, args)
        self.hStopSignal = win32event.CreateEvent(None, 0, 0, None)      
    
    def SvcStop(self):
        self.ReportServiceStatus(win32service.SERVICE_STOP_PENDING)
        win32event.SetEvent(self.hStopSignal)
    
    def SvcDoRun(self):
        POP3 = ServerThread(pop3filter.StartPOP3Server)
        POP3.start()
        win32event.WaitForSingleObject(self.hStopSignal,win32event.INFINITE)

if __name__=='__main__':
    win32serviceutil.HandleCommandLine(pop3filterService)

