import sys, socket, SocketServer, os, traceback, poplib, email, time, pop3trace
import StringIO, spamcheck

CURRENT_VERSION = 0.7

from email import Encoders
from email.MIMEText import MIMEText

# usage on windows
from pop3config import *
    
ERR_UNKNOWN = '-ERR unknown command\r\n'

trace = pop3trace.trace

spamcheck.CACHE_FILENAME = CACHE_FILENAME

class POP3Server(SocketServer.TCPServer):
    allow_reuse_address = 1
    def server_bind(self):
        """Override server_bind to store the server name."""
        SocketServer.TCPServer.server_bind(self)
        host, port = self.socket.getsockname()
        self.server_name = socket.getfqdn(host)
        self.server_port = port

def isSpamMail(lines,body):
    for i in xrange(len(lines)):
        l = lines[i].strip()
        if len(l) == 0:
            headers = lines[:i]
            trace("HEADERS='%s'\n" % ("\n".join(headers)))
            return spamcheck.CheckHeaderForSpam(headers)
    return 0

def getHeaderDict(msgdata):
    result = {
        'from': '',
        'to': '',
        'subject': '',
        'date': ''
    }

    # check subject
    for line in msgdata.splitlines():
        line = line.strip()
        if not line:
            break
        if line[:5].lower() == "from:":
            result['from'] = line[5:].strip().lower()
        if line[:3].lower() == "to:":
            result['to'] = line[3:].strip().lower()
        if line[:5].lower() == "date:":
            result['date'] = line[5:].strip().lower()
        if line[:8].lower() == "subject:":
            result['subject'] = line[8:].strip().lower()

    return result

class POP3RequestHandler(SocketServer.ThreadingMixIn, SocketServer.StreamRequestHandler):

    def SendResponse(self,msg,displaymsg=1):
        if displaymsg:        
            trace( "WRITE:" + msg )
        else:
            trace("(Transmitting mail body)\n")
        self.wfile.write(msg)
        self.wfile.flush()

    def handle(self):
        self.p = poplib.POP3(REMOTE_POP3_SERVER)
        welcome = self.p.getwelcome()
        trace("New session starting at %s" % time.ctime())
        self.SendResponse(welcome+"\r\n")
        self.terminated = 0
        while not self.terminated:
            self.inputline = self.rfile.readline().strip()

            if self.inputline[:5].upper() in ('PASS:','PASS '):
                trace("READ: PASS: *******\n")
            else:
                trace("READ:" + self.inputline)
            request = self.inputline.split()
            if len(request):
                request[0] = request[0].upper()
                func = getattr(self, request[0])
                if func:
                    try:
                        func(request)
                    except Exception, args:
                        traceback.print_exc(file=pop3trace.getTraceFile())
                        self.SendResponse(ERR_UNKNOWN)                    
                else:
                    trace("OK, func '%s' not found" % request[0])
                    self.SendResponse(ERR_UNKNOWN)
            else:
                break
        trace("connection shutdown")

    def USER(self,request):
        self.SendResponse(self.p.user(request[1])[0] + "\r\n")

    def PASS(self,request):
        self.SendResponse(self.p.pass_(request[1])[0] + "\r\n")

    def UIDL(self,request):
        if len(request) > 1:
            response = self.p.uidl(int(request[1]))
        else:
            response = self.p.uidl()
        result = response[0] + "\r\n" + "\r\n".join(response[1]) + "\r\n.\r\n"
        self.SendResponse(result)

    def RETR(self,request):
        response = self.p.retr(int(request[1]))
        self.SendResponse(response[0] + "\r\n" + self.CreateByteStuffedMessage(response[1]), 0)

    def CreateByteStuffedMessage(self, lines):
        msgdata = "\n".join( lines )
      
        global MSG_DIRECTORY, UNIQUE_MESSAGE_ID
        if MSG_DIRECTORY is not None:
            filename = os.path.join(MSG_DIRECTORY, "MSG%04d-%s.txt" % (UNIQUE_MESSAGE_ID,"-".join(map(str,time.localtime())[:6])) )
            UNIQUE_MESSAGE_ID += 1
            f = open(filename,"w")
            f.write(msgdata)
            f.close()
            trace("Dumped message as '%s'" % filename)

        if spamcheck.IgnoreThisMail(lines):
            trace("Message will not be further analyzed, because it is on one or more IGNORE rules")
        else:
            msg = getHeaderDict(msgdata)
            msg_from, msg_to, msg_subject, msg_date = msg["from"], msg["to"], msg["subject"], msg["date"]
            
            isspam = isSpamMail(lines, msgdata)
            if isspam:
                trace(isspam)
                try:
                    msg = MIMEText("pop3filter recognized the following mail as SPAM.\n"+isspam+":\n\n" + msgdata, _encoder=Encoders.encode_quopri)
                    msg['Subject'] = "[spam] " + msg_subject.strip()
                    msg['From'] = msg_from
                    msg['Date'] = msg_date
                    msg['To'] = msg_to
                    msgdata = str(msg)
                    lines = msgdata.splitlines()
                except:
                    traceback.print_exc(file=pop3trace.getTraceFile())
            elif msgdata.find("<html>") > 0 or msgdata.find("text/html") > 0:
                try:
                    msg = MIMEText("pop3filter removed HTML from the following mail:\n\n" + msgdata, _encoder=Encoders.encode_quopri)
                    msg['Subject'] = "[HTML] " + msg_subject.strip()
                    msg['From'] = msg_from
                    msg['Date'] = msg_date
                    msg['To'] = msg_to
                    msgdata = str(msg)
                    lines = msgdata.splitlines()
                except:
                    traceback.print_exc(file=pop3trace.getTraceFile())

        # now, bytestuff the message
        trace("ok, sending message now")
        del msgdata
        for i in xrange(len(lines)):
            if lines[i][:1] == '.':
                lines[i] = '.' + lines[i]
        response = "\r\n".join(lines) + "\r\n"
        
        #for line in lines:
        #    if len(line) and line[0] == '.':
        #        line = '.' + line
        #    response += line + "\r\n"
        response = response + ".\r\n"
        trace("response has %d bytes" % len(response))
        return response
    
    def DELE(self,request):
        self.SendResponse(self.p.dele(int(request[1]))[0] + "\r\n")

    def STAT(self,request):
        msgcount, msgsize = self.p.stat()
        self.SendResponse("+OK %d %d\r\n" % (msgcount, msgsize))

    def RSET(self,request):
        self.SendResponse(self.p.rset()[0] + "\r\n")

    def TOP(self,request):
        response = self.p.top(int(request[1]), int(request[2]))
        result = response[0] + "\r\n" + "\r\n".join(response[1]) + "\r\n.\r\n"
        self.SendResponse(result)
             
    def QUIT(self,request):
        self.SendResponse(self.p.quit() + "\r\n")
        self.terminated = 1

    def XSENDER(self,request):
        self.SendResponse("+OK\r\n")

    def LIST(self,request):
        if len(request) > 1:
            response = self.p.list(int(request[1]))
        else:
            response = self.p.list()
        result = response[0] + "\r\n" + "\r\n".join(response[1]) + "\r\n.\r\n"
        self.SendResponse(result)

    def AUTH(self,request):
        self.SendResponse(self.p.apop(request[1], request[2])[0] + "\r\n")

    def APOP(self,request):
        self.SendResponse(self.p.apop(request[1], request[2])[0] + "\r\n")

    def RPOP(self,request):
        self.SendResponse(self.p.rpop(request[1], request[2])[0] + "\r\n")

def StartPOP3Server():
    try:
        if os.name == "nt":
            # on NT, read from registrxy
            ReadSettingsFromRegistry()
        else:
            # default: read from config file
            ReadSettingsFromFile('/etc/pop3filter.cfg')

        pop3trace.setTraceFileName(LOGFILE_NAME)

        global UNIQUE_MESSAGE_ID
        UNIQUE_MESSAGE_ID = 0

        if HAMSTER_RULES is not None:
            import hamsterrules
            trace("reading HAMSTER-rules from '%s'" % HAMSTER_RULES)
            hamsterrules.ReadHamsterRules(HAMSTER_RULES)
        
        
        server = POP3Server(('', 110), POP3RequestHandler)
        trace("POP3Filter %s starting" % CURRENT_VERSION)
        server.serve_forever()
        trace("POP3Filter stopped")
    except:
        traceback.print_exc(file=logfile)

if __name__ == '__main__':
    StartPOP3Server()

