import os, ConfigParser, traceback

# DEFAULT VALUES
REMOTE_POP3_SERVER = ""
LOGFILE_NAME = None
MSG_DIRECTORY = None
HAMSTER_RULES = None
CACHE_FILENAME = None

def ReadSettingsFromFile(filename):
    try:
        
        config = ConfigParser.ConfigParser()
        config.readfp(open(filename))

        def getOption(option):
            try:
                value = config.get("SETTINGS",option)
                if value == "None":
                    value = None
                return value
            except:
                pass
            

        global REMOTE_POP3_SERVER
        REMOTE_POP3_SERVER = getOption("REMOTE_POP3_SERVER")

        global LOGFILE_NAME        
        LOGFILE_NAME = getOption("LOGFILE_NAME")

        global MSG_DIRECTORY
        MSG_DIRECTORY = getOption("MSG_DIRECTORY")

        global HAMSTER_RULES
        HAMSTER_RULES = getOption("HAMSTER_RULES")
        
        global CACHE_FILENAME
        CACHE_FILENAME = getOption("CACHE_FILENAME")        

    except:
        print "ERROR READING CONFIG FILE '%s'" % filename
        traceback.print_exc()

def ReadSettingsFromRegistry():
    try:
        import _winreg
        key = _winreg.OpenKey(_winreg.HKEY_LOCAL_MACHINE,"SOFTWARE\\p-nand-q.com\\pop3filter",_winreg.KEY_READ|_winreg.KEY_WRITE)

        def getOption(option):
            try:
                data = _winreg.QueryValueEx( key, option )
                data = str(data[0])
                if data == "None":
                    data = None
                return data
            except:
                pass    
        
        global REMOTE_POP3_SERVER
        REMOTE_POP3_SERVER = getOption("REMOTE_POP3_SERVER")

        global LOGFILE_NAME        
        LOGFILE_NAME = getOption("LOGFILE_NAME")

        global MSG_DIRECTORY
        MSG_DIRECTORY = getOption("MSG_DIRECTORY")

        global HAMSTER_RULES
        HAMSTER_RULES = getOption("HAMSTER_RULES")

        global CACHE_FILENAME
        CACHE_FILENAME = getOption("CACHE_FILENAME")

        _winreg.CloseKey(key)
    except:
        print "ERROR READING CONFIG REGISTRY"
        traceback.print_exc()
    
if os.name == "nt":
    # on NT, read from registrxy
    ReadSettingsFromRegistry()
else:
    # default: read from config file
    ReadSettingsFromFile('/etc/pop3filter.cfg')


