# Parser fr Hamster-Style Rules

import re, traceback

# rules for ip addresses 
IPAddressRules = []

# rules for subjects
SubjectRules = []

def ReadHamsterRules(filename):
    try:
        def getRule(line):
            x = line.find(":")
            assert(x >= 0)
            rule = line[x:].strip()
            if rule[0] == '{':
                rule = rule[1:]
            if rule[-1] == '}':
                rule = rule[:-1]
            return rule.replace("\b",".")
        
        tempReceived, tempSubjects = [], []
        for line in open(filename).readlines():
            tokens = line.split()
            if tokens and tokens[0].lower() == "=kill()":
                if tokens[1].lower() == "~subject:":
                    tempSubjects.append( getRule(line) )
                elif tokens[1].lower() == "*received:":
                    tempReceived.append( getRule(line) )

        while len(tempReceived):
            IPAddressRules.append( re.compile( "|".join(tempReceived[:50]) ) )
            tempReceived = tempReceived[50:]

        while len(tempSubjects):
            SubjectRules.append( re.compile( "|".join(tempSubjects[:50]) ) )
            tempSubjects = tempSubjects[50:]

    except:
        print "ERROR while loading filter rules from '%s'" % filename
        traceback.print_exc()

