"""

This is a modified brainfuck (TM) interpreter.

- The "," command reads from the given email keyword. It reads 0 at end-of-string
- The "." command exists the interpreter and causes the mail to be filtered.

You can get a "normal" bf interpreter by changing the code for "." and "," as indicated in
the commented-out section...

"""

def brainfuck(a,d):
    m, x, i, b = [0] * 64000, 0, 0, len(a)
    while i < b:
        c = a[i]
        i+=1
        if c == '>':
            x += 1
        elif c == '<':
            x -= 1
        elif c == '-':
            m[x] -= 1
        elif c == '+':
            m[x] += 1
        elif c == ',':
            # m[x]=sys.stdin.read(1)
            if len(d):
                m[x] = ord(d[0])
                d = d[1:]
            else:
                m[x] = 0
        elif c == '.':
            # sys.stdout.write(chr(m[x]))
            return 1
        elif c == '[':
            if not m[x]:
                p = 1
                while i < b:
                    c = a[i]
                    i += 1
                    if not p: break
                    if c == '[': p+=1
                    elif c == ']': p-=1
        elif c == ']':
            if m[x]:
                p, i = 1, i-1
                while i >= 0:
                    i -= 1
                    c = a[i]           
                    if not p: break
                    if c == '[': p-=1
                    elif c == ']': p+=1
                i += 1
